#--------------------------------------------------------
#	Script PiXYZ STUDIO - Batch Import Directory IO
#
#	This Python script is meant to be used in PiXYZ STUDIO.batch 2018 (requires the IO token)
#	Open the script in STUDIO Script window, and click the Execute button (CTRL+E)
#	Requires the file FileUtils.py to be placed in the same folder as this script
#
#	Copyright PiXYZ Software - 2018
#--------------------------------------------------------

from pxz import *
from FileUtils import *
from os.path import join

# EDITABLE SETTINGS
inputDirectory = "C:/Users/~username~/Desktop/InputDirectory"
fileFormat = "CATPart"
#--------------------------------------------------------

# CAD IMPORT  -  DO NOT MODIFY
inputFiles = getFilesInDirectory(inputDirectory, [fileFormat], True, False)

# Batch Import process
for inputFile in inputFiles:
    # Imports the file(s) from the input directory
    io.importScene(join(inputDirectory,inputFile))
#--------------------------------------------------------

# Saves the scene as a *.pxz fime
core.save(join(inputDirectory,"BatchImport.pxz"))
